﻿drop table Lineups; drop table Games; drop table Players;

create table Players(
player_id int primary key, -- номер на футболке
first_name varchar(50) not null,
last_name varchar(50) not null,
nickname varchar(50) not null, -- имя на футболке
citizenship varchar(50), -- гражданство, если NULL, то гражданин той страны, где проводится чемпионат
dob date not null, -- дата рождения
role varchar(20) not null -- амплуа, например, защитник 
);

-- Игры
create table Games(
game_id int primary key,
team varchar(30) not null, -- команда-соперник
city varchar(30), -- город, где проводится матч; NULL, если дома
goals smallint, -- голы, которые забил соперник; NULL, если не было забито
game_date timestamp not null, -- дата/время матча
own smallint -- aвтоголы, null, если таких не было
);

-- Участие в игре
create table Lineups(
"start" char not NULL, -- 'B' - игрок вышел в стартовом составе, 'S' - в запасе
game_id int references games,
player_id int references Players,
time_in int, -- число минут, проведенных игроком на поле; NULL, если не выходил.
goals smallint, -- число голов, которые игрок забил в матче; NULL, если не забивал
cards char(2), -- Y - желтая, Y2 - две желтых, R - красная, YR - желтая+красная; NULL, если карточек нет 
primary key(game_id, player_id)
);

SET DEFINE OFF;
insert into Games values
(1,'West Ham United',NULL,null,timestamp'2018-08-12 13:30:00',null);
insert into Games values(2,'Crystal Palace','London',null,timestamp'2018-08-20 20:00:00',null);
insert into Games values(3,'Brighton & Hove Albion',NULL,null,timestamp'2018-08-25 17:30:00',null);
insert into Games values(4,'Leicester City','Leicester',1,timestamp'2018-09-01 12:30:00',null);
insert into Games values(5,'Tottenham Hotspur','London',1,timestamp'2018-09-15 12:30:00',null);
insert into Games values(6,'Southampton',null,null,timestamp'2018-09-22 15:00:00',1);
insert into Games values(7,'Chelsea','London',1,timestamp'2018-09-29 17:30:00',null);
insert into Games values(8,'Manchester City',null,null,timestamp'2018-10-07 16:30:00',null);
insert into Games values(9,'Huddersfield Town','Huddersfield',null,timestamp'2018-10-20 17:30:00',null);
insert into Games values(10,'Cardiff City',null,1,timestamp'2018-10-27 15:00:00',null);
insert into Games values(11,'Arsenal','London',1,timestamp'2018-11-03 17:30:00',null);
insert into Games values(12,'Fulham',null,null,timestamp'2018-11-11 12:00:00',null);
insert into Games values(13,'Watford','Watford',null,timestamp'2018-11-24 15:00:00',null);
insert into Games values(14,'Everton',null,null,timestamp'2018-12-02 16:15:00',null);
insert into Games values(15,'Burnley','Burnley',1,timestamp'2018-12-05 19:45:00',null);
insert into Games values(16,'Bournemouth','Bournemouth',null,timestamp'2018-12-08 12:30:00',1);
insert into Games values(17,'Manchester United',null,1,timestamp'2018-12-16 16:00:00',null);
insert into Games values(18,'Wolverhampton Wanderers','Wolverhampton',null,timestamp'2018-12-21 20:00:00',null);
insert into Games values(19,'Newcastle United',NULL,null,timestamp'2018-12-26 15:00:00',null);
insert into Games values(20,'Arsenal',NULL,1,timestamp'2018-12-29 17:30:00',null);
insert into Games values(21,'Manchester City','Manchester',2,timestamp'2019-01-03 20:00:00',null);
insert into Games values(22,'Brighton & Hove Albion','Brighton',null,timestamp'2019-01-12 15:00:00',null);
insert into Games values(23,'Crystal Palace',null,3,timestamp'2019-01-19 15:00:00',null);
insert into Games values(24,'Leicester City',null,1,timestamp'2019-01-30 20:00:00',null);
insert into Games values(25,'West Ham United','London',1,timestamp'2019-02-04 20:00:00',null);
insert into Games values(26,'Bournemouth',null,null,timestamp'2019-02-09 15:00:00',null);
insert into Games values(27,'Manchester United','Manchester',null,timestamp'2019-02-24 14:05:00',null);
insert into Games values(28,'Watford',null,null,timestamp'2019-02-27 20:00:00',null);
insert into Games values(29,'Everton','Liverpool',null,timestamp'2019-03-03 16:15:00',null);
insert into Games values(30,'Burnley',null,2,timestamp'2019-03-10 12:00:00',null);
insert into Games values(31,'Fulham','London',1,timestamp'2019-03-17 14:15:00',null);
insert into Games values(32,'Tottenham Hotspur',null,1,timestamp'2019-03-31 16:30:00',1);
insert into Games values(33,'Southampton','Southampton',1,timestamp'2019-04-05 20:00:00',null);
insert into Games values(34,'Chelsea',null,null,timestamp'2019-04-14 16:30:00',null);
insert into Games values(35,'Cardiff City','Cardiff',null,timestamp'2019-04-21 16:00:00',null);
insert into Games values(36,'Huddersfield Town',null,null,timestamp'2019-04-26 20:00:00',null);
insert into Games values(37,'Newcastle United','Newcastle upon Tyne',2,timestamp'2019-05-04 19:45:00',null);
insert into Games values(38,'Wolverhampton Wanderers',null,null,timestamp'2019-05-12 15:00:00',NULL);

--
insert into players values(1,'Loris','Karius','Karius','Germany',date'1993-06-22','GOALKEEPER');
insert into players values(2,'Nathaniel','Clyne','Clyne',NULL,date'1991-04-05','DEFENDER');
insert into players values(3,'Fabio Henrique','Tavares','Fabinho','Brazil',date'1993-10-23','MIDFIELDER');
insert into players values(4,'Virgil','Van Dijk','Virgil','Netherland',date'1991-07-08','DEFENDER');
insert into players values(5,'Georginio','Wijnaldum','Wijnaldum','Netherland',date'1990-11-11','MIDFIELDER');
insert into players values(8,'Naby','Keita','Keita','Guinea',date'1995-02-10','MIDFIELDER');
insert into players values(9,'Robert','Firmino','Firmino','Brazil',date'1991-10-02','FORWARD');
insert into players values(10,'Sadio','Mane','Mane','Senegal',date'1992-04-10','FORWARD');
insert into players values(11,'Mohamed','Salah','M.Salah','Egypt',date'1992-06-15','FORWARD');
insert into players values(12,'Joe','Gomez','Gomez',NULL,date'1997-05-23','DEFENDER');
insert into players values(13,'Alisson','Becker','A.Becker','Brazil',date'1992-10-02','GOALKEEPER');
insert into players values(14,'Jordan','Henderson','Henderson',NULL,date'1990-06-17','MIDFIELDER');
insert into players values(18,'Alberto','Moreno','Moreno','Spain',date'1992-07-05','DEFENDER');
insert into players values(21,'Alex','Oxlade-Chamberlain','Oxlade-Chamberlain',NULL,date'1993-08-15','MIDFIELDER');
insert into players values(23,'Xherdan','Shaqiri','Shaqiri','Switzerland',date'1991-10-10','MIDFIELDER');
insert into players values(26,'Andy','Robertson','Robertson','Scotland',date'1994-03-11','DEFENDER');
insert into players values(27,'Divock','Origi','Origi','Belgia',date'1995-04-18','FORWARD');
insert into players values(29,'Dominic','Solanke','Solanke','Belgia',date'1997-09-14','FORWARD');
insert into players values(32,'Joel','Matip','Matip','Germany',date'1991-08-08','DEFENDER');
insert into players values(47,'Nathaniel','Phillips','Phillips',NULL,date'1997-03-21','DEFENDER');
insert into players values(50,'Lazar','Markovic','Markovic','Serbia',date'1994-03-02','MIDFIELDER');
insert into players values(53,'Ovie','Ejaria','Ejaria',NULL,date'1997-11-18','MIDFIELDER');
insert into players values(62,'Caoimhin','Kelleher','Kelleher','Ireland',date'1998-11-23','GOALKEEPER');
insert into players values(66,'Trent','Alexander-Arnold','Alexander-Arnold',NULL,date'1998-10-07','DEFENDER');
insert into players values(68,'Pedro','Chirivella','Chirivella','Spain',date'1997-05-23','MIDFIELDER');
insert into players values(73,'Kamil','Grabara','Grabara','Poland',date'1999-01-08','GOALKEEPER');
--
insert into Lineups values
('B',1,13,90,null,null);
insert into lineups values('B',1,26,90,null,null);
insert into lineups values('B',1,4,90,null,null);
insert into lineups values('B',1,12,90,null,null);
insert into lineups values('B',1,66,90,null,'Y');
insert into lineups values('B',1,7,90,null,null);
insert into lineups values('B',1,8,90,null,null);
insert into lineups values('B',1,5,90,null,null);
insert into lineups values('B',1,10,82,2,null);
insert into lineups values('B',1,11,87,1,null);
insert into lineups values('B',1,9,69,null,null);

insert into lineups values('S',1,2,NULL,null,null);
insert into lineups values('S',1,23,8,null,null);
insert into lineups values('S',1,15,3,1,null);
insert into lineups values('S',1,3,null,null,null);
insert into lineups values('S',1,1,null,null,null);
insert into lineups values('S',1,20,null,null,null);
insert into lineups values('S',1,14,21,null,null);
--
insert into lineups values('B',2,13,90,null,null);
insert into lineups values('B',2,26,90,null,null);
insert into lineups values('B',2,4,90,null,null);
insert into lineups values('B',2,12,90,null,null);
insert into lineups values('B',2,66,90,null,'Y'); 
insert into lineups values('B',2,7,67,1,NULL);
insert into lineups values('B',2,8,87,null,null);
insert into lineups values('B',2,5,90,null,null);
insert into lineups values('B',2,10,90,1,null);
insert into lineups values('B',2,11,90,null,null);
insert into lineups values('B',2,9,89,null,null);

insert into lineups values('S',2,18,NULL,null,null);
insert into lineups values('S',2,20,3,null,null);
insert into lineups values('S',2,22,null,null,null);
insert into lineups values('S',2,32,null,null,null);
insert into lineups values('S',2,23,null,null,null);
insert into lineups values('S',2,15,1,null,null);
insert into lineups values('S',2,14,23,null,null);
--
insert into lineups values('B',3,13,90,null,null);
insert into lineups values('B',3,26,90,null,null);
insert into lineups values('B',3,4,90,null,null);
insert into lineups values('B',3,12,90,null,null);
insert into lineups values('B',3,66,89,null,'Y'); 
insert into lineups values('B',3,7,90,null,null);
insert into lineups values('B',3,8,67,null,null);
insert into lineups values('B',3,5,90,null,null);
insert into lineups values('B',3,10,80,null,null);
insert into lineups values('B',3,11,90,1,null);
insert into lineups values('B',3,9,90,null,null);
insert into lineups values('S',3,18,NULL,null,null);
insert into lineups values('S',3,20,null,null,null);
insert into lineups values('S',3,22,null,null,null);
insert into lineups values('S',3,32,1,null,null);
insert into lineups values('S',3,23,null,null,null);
insert into lineups values('S',3,15,10,null,null);
insert into lineups values('S',3,14,23,null,null);
--
insert into lineups values('B',4,13,90,null,null);
insert into lineups values('B',4,26,90,null,null);
insert into lineups values('B',4,4,90,null,'Y');
insert into lineups values('B',4,12,90,null,null);
insert into lineups values('B',4,66,89,null,null); 
insert into lineups values('B',4,7,90,null,'Y');
insert into lineups values('B',4,14,71,null,null);
insert into lineups values('B',4,5,90,null,null);
insert into lineups values('B',4,10,90,1,null);
insert into lineups values('B',4,11,71,null,null);
insert into lineups values('B',4,9,90,1,null);

insert into lineups values('S',4,18,NULL,null,null);
insert into lineups values('S',4,20,null,null,null);
insert into lineups values('S',4,22,null,null,null);
insert into lineups values('S',4,32,1,null,null);
insert into lineups values('S',4,23,19,null,null);
insert into lineups values('S',4,15,10,null,null);
insert into lineups values('S',4,8,19,null,null);
--
insert into lineups values('B',5,13,90,null,null);
insert into lineups values('B',5,26,90,null,null);
insert into lineups values('B',5,4,90,null,null);
insert into lineups values('B',5,12,90,null,null);
insert into lineups values('B',5,66,89,null,null); 
insert into lineups values('B',5,7,90,null,null);
insert into lineups values('B',5,8,83,null,null);
insert into lineups values('B',5,5,90,1,null);
insert into lineups values('B',5,10,90,null,null);
insert into lineups values('B',5,11,90,null,null);
insert into lineups values('B',5,9,74,1,null);

insert into lineups values('S',5,18,NULL,null,null);
insert into lineups values('S',5,3,null,null,null);
insert into lineups values('S',5,22,null,null,null);
insert into lineups values('S',5,32,1,null,null);
insert into lineups values('S',5,23,null,null,null);
insert into lineups values('S',5,15,7,null,null);
insert into lineups values('S',5,14,16,null,null);
--
insert into lineups values('B',6,13,90,null,null);
insert into lineups values('B',6,26,90,null,null);
insert into lineups values('B',6,4,55,null,null);
insert into lineups values('B',6,32,90,1,null);
insert into lineups values('B',6,66,90,null,null); 
insert into lineups values('B',6,14,90,null,null);
insert into lineups values('B',6,23,45,null,null);
insert into lineups values('B',6,5,70,null,null);
insert into lineups values('B',6,10,90,null,null);
insert into lineups values('B',6,11,90,1,null);
insert into lineups values('B',6,9,90,null,null);
insert into lineups values('S',6,18,NULL,null,null);
insert into lineups values('S',6,8,20,null,null);
insert into lineups values('S',6,22,null,null,null);
insert into lineups values('S',6,12,35,null,null);
insert into lineups values('S',6,3,null,null,null);
insert into lineups values('S',6,15,null,null,null);
insert into lineups values('S',6,7,45,null,null);
--
insert into lineups values('B',7,13,90,null,null);
insert into lineups values('B',7,26,90,null,null);
insert into lineups values('B',7,4,90,null,null);
insert into lineups values('B',7,12,90,null,null);
insert into lineups values('B',7,66,90,null,null); 
insert into lineups values('B',7,14,78,null,null);
insert into lineups values('B',7,7,86,null,'Y');
insert into lineups values('B',7,5,90,null,null);
insert into lineups values('B',7,10,90,null,'Y');
insert into lineups values('B',7,11,66,null,null);
insert into lineups values('B',7,9,90,null,null);

insert into lineups values('S',7,18,NULL,null,null);
insert into lineups values('S',7,8,12,null,null);
insert into lineups values('S',7,22,null,null,null);
insert into lineups values('S',7,3,null,null,null);
insert into lineups values('S',7,15,4,1,null);
insert into lineups values('S',7,23,24,null,null);
insert into lineups values('S',7,32,null,null,null);
--
insert into lineups values('B',8,13,90,null,null);
insert into lineups values('B',8,26,90,null,null);
insert into lineups values('B',8,4,90,null,null);
insert into lineups values('B',8,12,90,null,null);
insert into lineups values('B',8,6,90,null,null); 
insert into lineups values('B',8,14,90,null,null);
insert into lineups values('B',8,7,29,null,null);
insert into lineups values('B',8,5,90,null,'Y');
insert into lineups values('B',8,10,90,null,null);
insert into lineups values('B',8,11,66,null,null);
insert into lineups values('B',8,9,72,null,null);

insert into lineups values('S',8,66,NULL,null,null);
insert into lineups values('S',8,8,61,null,null);
insert into lineups values('S',8,22,null,null,null);
insert into lineups values('S',8,3,null,null,null);
insert into lineups values('S',8,15,18,null,null);
insert into lineups values('S',8,23,null,null,null);
insert into lineups values('S',8,32,null,null,null);
--
insert into lineups values('B',9,13,90,null,null);
insert into lineups values('B',9,12,90,null,null);
insert into lineups values('B',9,4,90,null,null);
insert into lineups values('B',9,26,90,null,null);
insert into lineups values('B',9,6,90,null,null); 
insert into lineups values('B',9,7,77,null,null);
insert into lineups values('B',9,14,45,null,null);
insert into lineups values('B',9,23,90,null,null);
insert into lineups values('B',9,11,90,1,null);
insert into lineups values('B',9,15,90,null,'Y');
insert into lineups values('B',9,20,69,null,'Y');

insert into lineups values('S',9,3,21,null,null);
insert into lineups values('S',9,5,45,null,null);
insert into lineups values('S',9,66,NULL,null,null);
insert into lineups values('S',9,22,null,null,null);
insert into lineups values('S',9,32,null,null,null);
insert into lineups values('S',9,27,null,null,null);
insert into lineups values('S',9,9,13,null,null);
--
insert into lineups values('B',10,13,90,null,null);
insert into lineups values('B',10,6,90,null,null); 
insert into lineups values('B',10,66,90,null,null);
insert into lineups values('B',10,18,90,null,null);
insert into lineups values('B',10,4,90,null,null);
insert into lineups values('B',10,3,90,null,null);
insert into lineups values('B',10,20,61,null,null);
insert into lineups values('B',10,5,90,null,null);
insert into lineups values('B',10,9,71,null,null);
insert into lineups values('B',10,10,90,2,null);
insert into lineups values('B',10,11,90,1,null);

insert into lineups values('S',10,26,null,null,null);
insert into lineups values('S',10,7,19,null,null);
insert into lineups values('S',10,23,29,1,null);
insert into lineups values('S',10,15,null,null,null);
insert into lineups values('S',10,32,null,null,null);
insert into lineups values('S',10,22,null,null,null);
insert into lineups values('S',10,12,null,null,null);
--
insert into lineups values('B',11,13,90,null,null);
insert into lineups values('B',11,12,90,null,null);
insert into lineups values('B',11,4,90,null,null);
insert into lineups values('B',11,26,90,null,null);
insert into lineups values('B',11,66,90,null,null);
insert into lineups values('B',11,5,90,null,null);
insert into lineups values('B',11,3,90,null,'Y');
insert into lineups values('B',11,7,90,1,null);
insert into lineups values('B',11,10,90,null,null);
insert into lineups values('B',11,9,80,null,null);
insert into lineups values('B',11,11,89,null,null);
insert into lineups values('S',11,20,null,null,null);
insert into lineups values('S',11,22,null,null,null);
insert into lineups values('S',11,27,null,null,null); 
insert into lineups values('S',11,15,null,null,null);
insert into lineups values('S',11,32,1,null,null);
insert into lineups values('S',11,18,null,null,null);
insert into lineups values('S',11,23,10,null,null);
--
insert into lineups values('B',12,13,90,null,null);
insert into lineups values('B',12,26,90,null,null);
insert into lineups values('B',12,4,90,null,null);
insert into lineups values('B',12,66,90,null,null);
insert into lineups values('B',12,12,90,null,'Y');
insert into lineups values('B',12,3,89,null,null);
insert into lineups values('B',12,23,81,1,null);
insert into lineups values('B',12,9,90,null,null);
insert into lineups values('B',12,5,69,null,null);
insert into lineups values('B',12,10,90,null,null);
insert into lineups values('B',12,11,90,1,null);

insert into lineups values('S',12,14,21,null,null);
insert into lineups values('S',12,8,1,null,null);
insert into lineups values('S',12,22,null,null,null);
insert into lineups values('S',12,18,null,null,null);
insert into lineups values('S',12,6,null,null,null);
insert into lineups values('S',12,7,9,null,null);
insert into lineups values('S',12,15,null,null,null);
--
insert into lineups values('B',13,13,90,null,null);
insert into lineups values('B',13,26,90,null,null);
insert into lineups values('B',13,6,90,null,null);
insert into lineups values('B',13,66,90,1,null);
insert into lineups values('B',13,4,90,null,null);
insert into lineups values('B',13,5,90,null,null);
insert into lineups values('B',13,10,90,null,null);
insert into lineups values('B',13,23,74,null,null);
insert into lineups values('B',13,14,82,null,'Y2');
insert into lineups values('B',13,9,89,1,null);
insert into lineups values('B',13,11,86,1,null);
insert into lineups values('S',13,15,null,null,null);
insert into lineups values('S',13,7,16,null,null);
insert into lineups values('S',13,2,null,null,null);
insert into lineups values('S',13,32,1,null,null);
insert into lineups values('S',13,8,null,null,null);
insert into lineups values('S',13,3,4,null,null);
insert into lineups values('S',13,22,null,null,null);
--
insert into lineups values('B',14,13,90,null,null);
insert into lineups values('B',14,66,90,null,null);
insert into lineups values('B',14,26,90,null,null);
insert into lineups values('B',14,12,90,null,'Y');
insert into lineups values('B',14,4,90,null,null);
insert into lineups values('B',14,9,84,null,null);
insert into lineups values('B',14,23,71,null,'Y');
insert into lineups values('B',14,10,90,null,null);
insert into lineups values('B',14,5,90,null,null);
insert into lineups values('B',14,3,90,null,'Y');
insert into lineups values('B',14,11,75,null,null);
insert into lineups values('S',14,32,null,null,null);
insert into lineups values('S',14,18,null,null,null);
insert into lineups values('S',14,22,null,null,null);
insert into lineups values('S',14,7,null,null,null);
insert into lineups values('S',14,27,6,1,null);
insert into lineups values('S',14,15,15,null,null);
insert into lineups values('S',14,8,19,null,null);
--
insert into lineups values('B',15,13,90,null,null);
insert into lineups values('B',15,12,23,null,null);
insert into lineups values('B',15,4,90,null,null);
insert into lineups values('B',15,18,65,null,null);
insert into lineups values('B',15,32,90,null,null);
insert into lineups values('B',15,7,90,1,null);
insert into lineups values('B',15,8,90,null,null);
insert into lineups values('B',15,14,90,null,null);
insert into lineups values('B',15,23,90,1,null);
insert into lineups values('B',15,15,90,null,null);
insert into lineups values('B',15,27,66,null,null);
insert into lineups values('S',15,20,null,null,null);
insert into lineups values('S',15,11,25,null,null);
insert into lineups values('S',15,9,24,1,null);
insert into lineups values('S',15,22,null,null,null);
insert into lineups values('S',15,64,null,null,null);
insert into lineups values('S',15,66,67,null,null);
insert into lineups values('S',15,3,null,null,null);
--
insert into lineups values('B',16,13,90,null,null);
insert into lineups values('B',16,7,90,null,null);
insert into lineups values('B',16,26,90,null,null);
insert into lineups values('B',16,32,90,null,null);
insert into lineups values('B',16,4,90,null,null);
insert into lineups values('B',16,3,90,null,'Y');
insert into lineups values('B',16,23,65,null,null);
insert into lineups values('B',16,5,90,null,null);
insert into lineups values('B',16,8,65,null,null);
insert into lineups values('B',16,11,90,3,null);
insert into lineups values('B',16,9,81,null,null);
insert into lineups values('S',16,14,9,null,null);
insert into lineups values('S',16,27,null,null,null);
insert into lineups values('S',16,15,null,null,null);
insert into lineups values('S',16,20,25,null,null);
insert into lineups values('S',16,22,null,null,null);
insert into lineups values('S',16,10,25,null,null);
insert into lineups values('S',16,66,null,null,null);
--
insert into lineups values('B',17,13,90,null,null);
insert into lineups values('B',17,26,90,null,null);
insert into lineups values('B',17,6,90,null,null);
insert into lineups values('B',17,4,90,null,null);
insert into lineups values('B',17,2,90,null,null);
insert into lineups values('B',17,5,90,null,null);
insert into lineups values('B',17,8,70,null,null);
insert into lineups values('B',17,3,90,null,null);
insert into lineups values('B',17,10,84,1,null);
insert into lineups values('B',17,11,90,null,null);
insert into lineups values('B',17,9,90,null,null);
insert into lineups values('S',17,20,null,null,null);
insert into lineups values('S',17,22,null,null,null);
insert into lineups values('S',17,64,null,null,null);
insert into lineups values('S',17,14,6,null,null);
insert into lineups values('S',17,18,null,null,null);
insert into lineups values('S',17,15,null,null,null);
insert into lineups values('S',17,23,20,2,null);
--
insert into lineups values('B',18,13,90,null,null);
insert into lineups values('B',18,7,90,null,null);
insert into lineups values('B',18,4,90,1,null);
insert into lineups values('B',18,26,90,null,null);
insert into lineups values('B',18,6,90,null,null);
insert into lineups values('B',18,3,90,null,null);
insert into lineups values('B',18,8,58,null,null);
insert into lineups values('B',18,9,76,null,null);
insert into lineups values('B',18,14,90,null,null);
insert into lineups values('B',18,10,87,null,null);
insert into lineups values('B',18,11,90,1,null);
insert into lineups values('S',18,20,32,null,null);
insert into lineups values('S',18,2,3,null,null);
insert into lineups values('S',18,22,null,null,null);
insert into lineups values('S',18,15,null,null,null);
insert into lineups values('S',18,27,null,null,null);
insert into lineups values('S',18,5,24,null,null);
insert into lineups values('S',18,23,null,null,null);
--
insert into lineups values('B',19,13,90,null,null);
insert into lineups values('B',19,6,90,1,null);
insert into lineups values('B',19,4,90,null,null);
insert into lineups values('B',19,26,82,null,null);
insert into lineups values('B',19,66,90,null,null);
insert into lineups values('B',19,9,69,null,null);
insert into lineups values('B',19,10,90,null,null);
insert into lineups values('B',19,14,90,null,null);
insert into lineups values('B',19,23,90,1,null);
insert into lineups values('B',19,5,62,null,null);
insert into lineups values('B',19,11,90,1,null); 
insert into lineups values('S',19,8,NULL,null,null);
insert into lineups values('S',19,22,NULL,null,null);
insert into lineups values('S',19,20,NULL,null,null);
insert into lineups values('S',19,2,8,null,null);
insert into lineups values('S',19,27,NULL,null,null);
insert into lineups values('S',19,15,21,null,null);
insert into lineups values('S',19,3,28,1,null);
--
insert into lineups values('B',20,13,90,null,null);
insert into lineups values('B',20,4,90,null,null);
insert into lineups values('B',20,6,90,null,null);
insert into lineups values('B',20,66,90,null,null);
insert into lineups values('B',20,26,83,null,'Y');
insert into lineups values('B',20,10,62,1,null);
insert into lineups values('B',20,23,90,null,null);
insert into lineups values('B',20,3,90,null,null);
insert into lineups values('B',20,9,90,3,null);
insert into lineups values('B',20,5,78,null,null);
insert into lineups values('B',20,11,90,1,null); 
insert into lineups values('S',20,22,NULL,null,null);
insert into lineups values('S',20,8,NULL,null,null);
insert into lineups values('S',20,27,NULL,null,null);
insert into lineups values('S',20,14,28,null,null);
insert into lineups values('S',20,2,7,null,null);
insert into lineups values('S',20,20,12,null,null);
insert into lineups values('S',20,15,null,null,null);
--
insert into lineups values('B',21,13,90,null,null);
insert into lineups values('B',21,66,90,null,null);
insert into lineups values('B',21,26,90,null,null);
insert into lineups values('B',21,4,90,null,null);
insert into lineups values('B',21,6,90,null,'Y');
insert into lineups values('B',21,14,90,null,null);
insert into lineups values('B',21,5,86,null,'Y');
insert into lineups values('B',21,7,57,null,null);
insert into lineups values('B',21,11,90,null,null); 
insert into lineups values('B',21,10,77,null,null);
insert into lineups values('B',21,9,90,1,null);
insert into lineups values('S',21,3,23,null,null);
insert into lineups values('S',21,23,13,null,null);
insert into lineups values('S',21,22,NULL,null,null);
insert into lineups values('S',21,8,NULL,null,null);
insert into lineups values('S',21,20,null,null,null);
insert into lineups values('S',21,18,NULL,null,null);
insert into lineups values('S',21,15,4,null,null);
--
insert into lineups values('B',22,13,90,null,null);
insert into lineups values('B',22,66,90,null,null);
insert into lineups values('B',22,3,90,null,null);
insert into lineups values('B',22,26,90,null,null);
insert into lineups values('B',22,4,90,null,null);
insert into lineups values('B',22,5,90,null,null);
insert into lineups values('B',22,14,90,null,null);
insert into lineups values('B',22,9,90,null,null);
insert into lineups values('B',22,10,89,null,null);
insert into lineups values('B',22,23,72,null,null);
insert into lineups values('B',22,11,89,1,null); 
insert into lineups values('S',22,27,1,null,null);
insert into lineups values('S',22,18,NULL,null,null);
insert into lineups values('S',22,64,null,null,null);
insert into lineups values('S',22,32,null,null,null);
insert into lineups values('S',22,7,18,null,null);
insert into lineups values('S',22,22,NULL,null,null);
insert into lineups values('S',22,8,1,null,null);
--
insert into lineups values('B',23,13,90,null,null);
insert into lineups values('B',23,7,89,null,'Y2');
insert into lineups values('B',23,32,90,null,null);
insert into lineups values('B',23,4,90,null,null);
insert into lineups values('B',23,26,90,null,null);
insert into lineups values('B',23,14,90,null,null);
insert into lineups values('B',23,9,90,1,null);
insert into lineups values('B',23,10,90,1,null);
insert into lineups values('B',23,3,87,null,null);
insert into lineups values('B',23,8,71,null,null);
insert into lineups values('B',23,11,89,2,null); 
insert into lineups values('S',23,20,3,null,null);
insert into lineups values('S',23,15,null,null,null);
insert into lineups values('S',23,22,NULL,null,null);
insert into lineups values('S',23,23,19,null,null);
insert into lineups values('S',23,18,NULL,null,null);
insert into lineups values('S',23,27,null,null,null);
insert into lineups values('S',23,64,1,null,null);
--
insert into lineups values('B',24,13,90,null,null);
insert into lineups values('B',24,32,90,null,'Y');
insert into lineups values('B',24,26,90,null,null);
insert into lineups values('B',24,4,90,null,null);
insert into lineups values('B',24,14,90,null,null);
insert into lineups values('B',24,8,66,null,null);
insert into lineups values('B',24,5,90,null,null);
insert into lineups values('B',24,10,90,1,null);
insert into lineups values('B',24,9,82,null,null);
insert into lineups values('B',24,23,67,null,null);
insert into lineups values('B',24,11,90,null,null); 
insert into lineups values('S',24,64,null,null,null);
insert into lineups values('S',24,22,NULL,null,null);
insert into lineups values('S',24,20,24,null,null);
insert into lineups values('S',24,3,23,null,null);
insert into lineups values('S',24,27,null,null,null);
insert into lineups values('S',24,15,8,null,null);
insert into lineups values('S',24,6,NULL,null,null);
--
insert into lineups values('B',25,13,90,null,null);
insert into lineups values('B',25,32,90,null,'Y');
insert into lineups values('B',25,26,90,null,null);
insert into lineups values('B',25,4,90,null,null);
insert into lineups values('B',25,7,90,null,null);
insert into lineups values('B',25,3,90,null,null);
insert into lineups values('B',25,8,90,null,null);
insert into lineups values('B',25,20,69,null,null);
insert into lineups values('B',25,11,90,null,null); 
insert into lineups values('B',25,9,75,null,null);
insert into lineups values('B',25,10,90,1,null);
insert into lineups values('S',25,22,NULL,null,null);
insert into lineups values('S',25,23,21,null,null);
insert into lineups values('S',25,64,null,null,null);
insert into lineups values('S',25,15,null,null,null);
insert into lineups values('S',25,18,null,null,null);
insert into lineups values('S',25,27,15,null,null);
insert into lineups values('S',25,48,NULL,null,null);
--
insert into lineups values('B',26,13,90,null,null);
insert into lineups values('B',26,32,90,null,'Y');
insert into lineups values('B',26,26,90,null,'Y');
insert into lineups values('B',26,4,90,null,null);
insert into lineups values('B',26,7,90,null,null);
insert into lineups values('B',26,5,77,1,null);
insert into lineups values('B',26,8,90,null,null);
insert into lineups values('B',26,3,90,null,null);
insert into lineups values('B',26,9,89,null,null);
insert into lineups values('B',26,10,87,1,null);
insert into lineups values('B',26,11,90,1,null); 
insert into lineups values('S',26,27,3,null,null);
insert into lineups values('S',26,15,1,null,null);
insert into lineups values('S',26,20,null,null,null);
insert into lineups values('S',26,14,null,null,null);
insert into lineups values('S',26,22,NULL,null,null);
insert into lineups values('S',26,66,13,null,null);
insert into lineups values('S',26,64,null,null,null);
--
insert into lineups values('B',27,13,90,null,null);
insert into lineups values('B',27,32,90,null,null);
insert into lineups values('B',27,7,90,null,'Y');
insert into lineups values('B',27,26,90,null,null);
insert into lineups values('B',27,4,90,null,null);
insert into lineups values('B',27,5,90,null,'Y');
insert into lineups values('B',27,14,72,null,null);
insert into lineups values('B',27,3,90,null,null);
insert into lineups values('B',27,9,31,null,null);
insert into lineups values('B',27,10,90,null,null);
insert into lineups values('B',27,11,79,null,null); 
insert into lineups values('S',27,15,59,null,null);
insert into lineups values('S',27,22,NULL,null,null);
insert into lineups values('S',27,27,11,null,null);
insert into lineups values('S',27,66,null,null,null);
insert into lineups values('S',27,20,null,null,null);
insert into lineups values('S',27,23,18,null,'Y');
insert into lineups values('S',27,8,null,null,null);
--
insert into lineups values('B',28,13,90,null,null);
insert into lineups values('B',28,66,90,null,null);
insert into lineups values('B',28,26,90,null,null);
insert into lineups values('B',28,4,90,2,null);
insert into lineups values('B',28,32,90,null,null);
insert into lineups values('B',28,7,70,null,null);
insert into lineups values('B',28,5,84,null,'Y');
insert into lineups values('B',28,3,90,null,null);
insert into lineups values('B',28,27,90,1,null);
insert into lineups values('B',28,11,90,null,null); 
insert into lineups values('B',28,10,78,2,null);
insert into lineups values('S',28,22,NULL,null,null);
insert into lineups values('S',28,64,null,null,null);
insert into lineups values('S',28,20,12,null,null);
insert into lineups values('S',28,8,6,null,null);
insert into lineups values('S',28,14,20,null,null);
insert into lineups values('S',28,15,null,null,null);
insert into lineups values('S',28,23,null,null,'Y');
--
insert into lineups values('B',29,13,90,null,null);
insert into lineups values('B',29,32,90,null,null);
insert into lineups values('B',29,26,90,null,'Y');
insert into lineups values('B',29,4,90,null,null);
insert into lineups values('B',29,66,90,null,null);
insert into lineups values('B',29,14,90,null,null);
insert into lineups values('B',29,3,90,null,'Y');
insert into lineups values('B',29,5,63,null,'Y');
insert into lineups values('B',29,11,90,null,null); 
insert into lineups values('B',29,10,84,null,null);
insert into lineups values('B',29,27,63,null,null);
insert into lineups values('S',29,9,27,null,null);
insert into lineups values('S',29,23,null,null,null);
insert into lineups values('S',29,8,null,null,null);
insert into lineups values('S',29,15,null,null,null);
insert into lineups values('S',29,20,6,null,null);
insert into lineups values('S',29,7,27,null,null);
insert into lineups values('S',29,22,NULL,null,null);
--
insert into lineups values('B',30,13,90,null,'Y');
insert into lineups values('B',30,32,90,null,null);
insert into lineups values('B',30,26,90,null,null);
insert into lineups values('B',30,4,90,null,null);
insert into lineups values('B',30,66,86,null,null);
insert into lineups values('B',30,3,90,null,'Y');
insert into lineups values('B',30,5,68,null,null);
insert into lineups values('B',30,20,77,null,null);
insert into lineups values('B',30,11,90,null,null); 
insert into lineups values('B',30,10,90,2,null);
insert into lineups values('B',30,9,90,2,null);
insert into lineups values('S',30,22,NULL,null,null);
insert into lineups values('S',30,27,null,null,null);
insert into lineups values('S',30,6,null,null,null);
insert into lineups values('S',30,14,22,null,null);
insert into lineups values('S',30,23,null,null,null);
insert into lineups values('S',30,8,13,null,null);
insert into lineups values('S',30,15,4,null,null);
--
insert into lineups values('B',31,13,90,null,null);
insert into lineups values('B',31,32,90,null,null);
insert into lineups values('B',31,66,90,null,null);
insert into lineups values('B',31,4,90,null,null);
insert into lineups values('B',31,26,90,null,null);
insert into lineups values('B',31,3,90,null,'Y');
insert into lineups values('B',31,5,90,null,null);
insert into lineups values('B',31,20,72,null,null);
insert into lineups values('B',31,11,89,null,null); 
insert into lineups values('B',31,10,90,1,null);
insert into lineups values('B',31,9,72,null,null);
insert into lineups values('S',31,22,NULL,null,null);
insert into lineups values('S',31,27,18,null,null);
insert into lineups values('S',31,6,null,null,null);
insert into lineups values('S',31,18,null,null,null);
insert into lineups values('S',31,23,null,null,null);
insert into lineups values('S',31,7,18,1,null);
insert into lineups values('S',31,15,1,null,null);
--
insert into lineups values('B',32,13,90,null,null);
insert into lineups values('B',32,32,90,null,null);
insert into lineups values('B',32,66,90,null,null);
insert into lineups values('B',32,4,90,null,null);
insert into lineups values('B',32,26,90,null,null);
insert into lineups values('B',32,14,77,null,null);
insert into lineups values('B',32,5,90,null,null);
insert into lineups values('B',32,7,77,null,null);
insert into lineups values('B',32,9,90,1,null);
insert into lineups values('B',32,11,89,null,null); 
insert into lineups values('B',32,10,90,null,null);
insert into lineups values('S',32,23,null,null,null);
insert into lineups values('S',32,20,null,null,null);
insert into lineups values('S',32,3,13,null,null);
insert into lineups values('S',32,6,1,null,null);
insert into lineups values('S',32,8,null,null,null);
insert into lineups values('S',32,22,NULL,null,null);
insert into lineups values('S',32,27,13,null,null);
--
insert into lineups values('B',33,13,90,null,null);
insert into lineups values('B',33,4,90,null,null);
insert into lineups values('B',33,26,90,null,'Y');
insert into lineups values('B',33,66,59,null,null);
insert into lineups values('B',33,32,90,null,null);
insert into lineups values('B',33,5,59,null,null);
insert into lineups values('B',33,3,90,null,null);
insert into lineups values('B',33,8,88,1,null);
insert into lineups values('B',33,9,90,null,null);
insert into lineups values('B',33,11,90,1,'Y'); 
insert into lineups values('B',33,10,90,null,'Y');
insert into lineups values('S',33,23,null,null,null);
insert into lineups values('S',33,27,null,null,null);
insert into lineups values('S',33,6,2,null,null);
insert into lineups values('S',33,22,null,null,null);
insert into lineups values('S',33,7,31,null,null);
insert into lineups values('S',33,14,31,1,'Y');
insert into lineups values('S',33,18,NULL,null,null);
--
insert into lineups values('B',34,13,90,null,null);
insert into lineups values('B',34,4,90,null,null);
insert into lineups values('B',34,26,90,null,null);
insert into lineups values('B',34,66,59,null,null);
insert into lineups values('B',34,32,90,null,null);
insert into lineups values('B',34,14,77,null,null);
insert into lineups values('B',34,8,66,null,null);
insert into lineups values('B',34,3,90,null,null);
insert into lineups values('B',34,9,90,null,null);
insert into lineups values('B',34,11,90,1,null); 
insert into lineups values('B',34,10,89,1,null);
insert into lineups values('S',34,5,24,null,null);
insert into lineups values('S',34,23,1,null,null);
insert into lineups values('S',34,27,null,null,null);
insert into lineups values('S',34,6,null,null,null);
insert into lineups values('S',34,22,null,null,null);
insert into lineups values('S',34,7,13,null,null);
insert into lineups values('S',34,15,NULL,null,null);
--
insert into lineups values('B',35,13,90,null,null);
insert into lineups values('B',35,4,90,null,null);
insert into lineups values('B',35,26,90,null,null);
insert into lineups values('B',35,66,86,null,null);
insert into lineups values('B',35,32,90,null,null);
insert into lineups values('B',35,5,90,1,null);
insert into lineups values('B',35,14,90,null,null);
insert into lineups values('B',35,8,71,null,null);
insert into lineups values('B',35,9,90,null,null);
insert into lineups values('B',35,11,90,null,null); 
insert into lineups values('B',35,10,90,null,null);
insert into lineups values('S',35,22,null,null,null);
insert into lineups values('S',35,12,4,null,null);
insert into lineups values('S',35,3,4,null,null);
insert into lineups values('S',35,23,null,null,null);
insert into lineups values('S',35,27,null,null,null);
insert into lineups values('S',35,7,15,1,'Y');
insert into lineups values('S',35,15,NULL,null,null);
--
insert into lineups values('B',36,13,90,null,null);
insert into lineups values('B',36,4,90,null,null);
insert into lineups values('B',36,26,90,null,null);
insert into lineups values('B',36,66,88,null,null);
insert into lineups values('B',36,6,90,null,null);
insert into lineups values('B',36,5,73,null,null);
insert into lineups values('B',36,8,90,1,null);
insert into lineups values('B',36,14,90,null,null);
insert into lineups values('B',36,15,73,null,null);
insert into lineups values('B',36,11,90,2,null); 
insert into lineups values('B',36,10,90,2,null);
insert into lineups values('S',36,27,null,null,null);
insert into lineups values('S',36,23,17,null,null);
insert into lineups values('S',36,22,null,null,null);
insert into lineups values('S',36,7,null,null,null);
insert into lineups values('S',36,21,17,null,null);
insert into lineups values('S',36,12,2,null,null);
insert into lineups values('S',36,32,null,null,null);
--
insert into lineups values('B',37,13,90,null,null);
insert into lineups values('B',37,4,90,1,null);
insert into lineups values('B',37,26,90,null,null);
insert into lineups values('B',37,66,90,null,null);
insert into lineups values('B',37,6,83,null,null);
insert into lineups values('B',37,5,66,null,null);
insert into lineups values('B',37,3,90,null,null);
insert into lineups values('B',37,14,90,null,null);
insert into lineups values('B',37,15,90,null,null);
insert into lineups values('B',37,11,73,1,null); 
insert into lineups values('B',37,10,90,null,null);
insert into lineups values('S',37,22,null,null,null);
insert into lineups values('S',37,12,null,null,null);
insert into lineups values('S',37,21,null,null,null);
insert into lineups values('S',37,7,7,null,'Y');
insert into lineups values('S',37,27,17,1,null);
insert into lineups values('S',37,23,24,null,null);
insert into lineups values('S',37,32,null,null,null);
--
insert into lineups values('B',38,13,90,null,null);
insert into lineups values('B',38,4,90,null,null);
insert into lineups values('B',38,26,84,null,null);
insert into lineups values('B',38,66,90,null,null);
insert into lineups values('B',38,32,90,null,null);
insert into lineups values('B',38,5,88,null,null);
insert into lineups values('B',38,3,90,null,null);
insert into lineups values('B',38,14,90,null,null);
insert into lineups values('B',38,27,64,null,null);
insert into lineups values('B',38,11,90,null,null); 
insert into lineups values('B',38,10,90,2,null);
insert into lineups values('S',38,6,null,null,null);
insert into lineups values('S',38,22,null,null,null);
insert into lineups values('S',38,12,6,null,null);
insert into lineups values('S',38,21,2,null,null);
insert into lineups values('S',38,7,26,null,null);
insert into lineups values('S',38,15,null,null,null);
insert into lineups values('S',38,23,null,null,NULL);
